TITLE   'Scanning Calorimetry, Polymer in Al'		         { exa192.pde }
SELECT     							
   errlim=1e-3     ngrid=1     spectral_colors
COORDINATES   ycylinder( 'r', 'z')
VARIABLES   temp( threshold=0.01)
DEFINITIONS
   D=0.1e-3     r0=3.3e-3     Lz=1.6e-3     k     rcp
   heat=0     rate=2.0    tempi=300
   fluxd_r=-k*dr(temp)     fluxd_z=-k*dz(temp)
   fluxd=vector( fluxd_r, fluxd_z)     fluxdm=magnitude( fluxd)
INITIAL VALUES
   temp=tempi
EQUATIONS
   div( fluxd)+ rcp*dt( temp)=heat
BOUNDARIES
region 'domain'   k=0.3   rcp=3e6                 			{ Polymer }
start (0,0)  value(temp)=tempi+ rate*t  line to (r0,0)
   natural(temp)=0  line to (r0,Lz) to (0,Lz) close
region  'aluminum'   k=238   rcp=3e6                		
   start (0,0)  line to (r0,0) to (r0,Lz) to (0,Lz)
   to (0,Lz-D) to (r0-D,Lz-D) to (r0-D,D) to (0,D) close
TIME   from 0 to 100
PLOTS
   for t=1, 3, 10, 30, 100
   elevation(temp) from (0,0) to (0,Lz)      contour(temp) painted
   surface(temp) viewpoint( -r0, Lz/2, 0)
END

